#! /bin/sh

# generic iHook logout script
#
# runs everything in /etc/hooks beginning with LO (for LogOut),
# similar in design to the SysV rc scripts.

export PATH=/bin:/usr/bin:/opt/local/bin:/sbin:/usr/sbin:/opt/local/sbin

HOOKSDIR="/etc/hooks"

# become front application, disable UI and show barberpole
echo %BACKGROUND ${RAIHOOKBACKGROUND}
echo %WINDOWLEVEL HIGH
echo %BECOMEKEY
echo %UIMODE AUTOCRATIC
echo %BEGINPOLE

if [ -d ${HOOKSDIR} ]; then
    for hook in ${HOOKSDIR}/LO*; do
	if [ -s ${hook} -a -x ${hook} ]; then
	    logger -s -t LogoutHook -p user.info Executing ${hook}... 1>&2

	    # run the item
	    ${hook} $*

	    if [ $? -ne 0 ]; then
		exit_value=$?
		logger -s -t LogoutHook -p user.info ${hook} failed! 1>&2
		exit $exit_value
	    fi
	fi
    done
fi

echo LogoutHook complete.
echo %ENDPOLE

sleep 1

exit 0
